package com.bxm.game.common.core.activity;

import com.bxm.game.common.core.AppContext;
import com.bxm.game.common.core.activity.dao.ActivityDao;

/**
 * @author allen
 * @date 2020-10-14
 * @since 1.0
 */
public class ActivityServiceImpl implements ActivityService {

    private final ActivityDao activityDao;

    public ActivityServiceImpl(ActivityDao activityDao) {
        this.activityDao = activityDao;
    }

    @Override
    public ActivityConfig getConfig() {
        return activityDao.get(AppContext.get().getAppId());
    }

    @Override
    public <T> T getConfig(Class<T> clazz) {
        return activityDao.getConfig(AppContext.get().getAppId(), clazz);
    }
}
