package com.bxm.game.common.core.archives.annotation;


import com.bxm.game.common.core.scene.SceneType;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 完成即删除
 *
 * @author allen
 * @date 2020-11-24
 * @since 1.0
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface DeleteOnCompleted {

    /**
     * 在这些场景下才会执行删除
     * @return 场景列表
     */
    String[] sceneTypes() default {SceneType.ACQUIRE, SceneType.MULTIPLE};
}
