package com.bxm.game.common.core.assets;

import com.bxm.game.common.core.assets.dao.AssetDao;

import java.util.Map;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;

/**
 * @author allen
 * @date 2020-11-26
 * @since 1.0
 */
@ConditionalOnMissingBean(AssetService.class)
public class AssetServiceImpl implements AssetService {

    private final AssetDao assetDao;

    public AssetServiceImpl(AssetDao assetDao) {
        this.assetDao = assetDao;
    }

    @Override
    public long plus(String type, long value) {
        return assetDao.plus(type, value);
    }

    @Override
    public long minus(String type, long value) {
        return assetDao.minus(type, value);
    }

    @Override
    public long get(String type) {
        return assetDao.get(type);
    }

    @Override
    public long get(String type, long defaultValue) {
        return assetDao.get(type, defaultValue);
    }

    @Override
    public void set(String type, long value) {
        assetDao.set(type, value);
    }

    @Override
    public void delete(String type) {
        assetDao.delete(type);
    }

    @Override
    public Map<String, Object> getAll() {
        return assetDao.getAll();
    }
}
