package com.bxm.game.common.core.assets.dao;

import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.core.Key;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.math.NumberUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * @author allen
 * @date 2020-12-15
 * @since 1.0
 */
public class RedisAssetDaoImpl implements AssetDao {

    private final AppConfigFetcher appConfigFetcher;
    private final Fetcher fetcher;
    private final Counter counter;
    private final Updater updater;
    private final Key key;

    public RedisAssetDaoImpl(AppConfigFetcher appConfigFetcher, Fetcher fetcher, Counter counter, Updater updater, Key key) {
        this.appConfigFetcher = appConfigFetcher;
        this.fetcher = fetcher;
        this.counter = counter;
        this.updater = updater;
        this.key = key;
    }

    @Override
    public long plus(String type, long value) {
        return counter.hincrementByAndGet(key.getUserAsset(appConfigFetcher.assetWithApp()), type, value);
    }

    @Override
    public long minus(String type, long value) {
        return counter.hincrementByAndGet(key.getUserAsset(appConfigFetcher.assetWithApp()), type, -value);
    }

    @Override
    public long get(String type) {
        return get(type, 0);
    }

    @Override
    public long get(String type, long defaultValue) {
        return Optional.ofNullable(fetcher.hfetch(key.getUserAsset(appConfigFetcher.assetWithApp()), type, Long.class)).orElse(defaultValue);
    }

    @Override
    public void set(String type, long value) {
        updater.hupdate(key.getUserAsset(appConfigFetcher.assetWithApp()), type, value);
    }

    @Override
    public void delete(String type) {
        updater.hremove(key.getUserAsset(appConfigFetcher.assetWithApp()), type);
    }

    @Override
    public Map<String, Object> getAll() {
        Map<String, Object> rst = new HashMap<>();
        Map<String, String> map = fetcher.hfetchall(key.getUserAsset(appConfigFetcher.assetWithApp()), String.class);
        if (MapUtils.isEmpty(map)) {
            return rst;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (NumberUtils.isCreatable(value)) {
                rst.put(key, NumberUtils.toInt(value));
            } else {
                rst.put(key, value);
            }
        }
        return rst;
    }
}
