package com.bxm.game.common.core.assets.dao;

import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.core.Key;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;

/**
 * @author allen
 * @date 2021-01-12
 * @since 1.0
 */
public class RedisObjectAssetDaoImpl implements ObjectAssetDao {

    private final AppConfigFetcher appConfigFetcher;
    private final Fetcher fetcher;
    private final Updater updater;
    private final Key key;

    public RedisObjectAssetDaoImpl(AppConfigFetcher appConfigFetcher, Fetcher fetcher, Updater updater, Key key) {
        this.appConfigFetcher = appConfigFetcher;
        this.fetcher = fetcher;
        this.updater = updater;
        this.key = key;
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        return fetcher.hfetch(this.key.getUserAsset(appConfigFetcher.assetWithApp()), key, clazz);
    }

    @Override
    public void set(String key, Object value) {
        updater.hupdate(this.key.getUserAsset(appConfigFetcher.assetWithApp()), key, value);
    }
}
