package com.bxm.game.common.core.controllers;

import com.bxm.game.common.core.scene.SceneRequest;
import com.bxm.game.common.core.scene.SceneResponse;
import com.bxm.game.common.core.scene.SceneService;
import com.bxm.game.common.core.scene.SceneServiceFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Objects;

/**
 * @author allen
 * @date 2020-10-16
 * @since 1.0
 */
@RestController
@RequestMapping("/scene")
public class SceneController {

    private final SceneServiceFactory factory;

    public SceneController(SceneServiceFactory factory) {
        this.factory = factory;
    }

    /**
     * 获取道具
     *
     * @param sceneType 场景
     * @param message 场景所需要的请求参数
     * @return 获取结果
     */
    @PostMapping("/take/{sceneType}")
    public ResponseEntity<SceneResponse> take(@PathVariable("sceneType") String sceneType,
                                              @RequestBody(required = false) String message) {
        SceneService service = factory.get(sceneType);
        if (Objects.isNull(service)) {
            return ResponseEntity.badRequest().build();
        }
        SceneRequest request = service.convert(message);
        SceneResponse response = service.take(request);
        return ResponseEntity.ok(response);
    }
}
