package com.bxm.game.common.core.job;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.dal.entity.AssetsLog;
import com.bxm.game.common.dal.service.IAssetsLogService;
import com.bxm.warcar.utils.NamedThreadFactory;

/**
 * 定时创建分表<br/>
 *
 * @author kerry.jiang
 * @date 2021/1/12 19:14
 */
public class TableJobServiceImpl implements TableJobService {


    private final AppConfigFetcher appConfigFetcher;
    private final IAssetsLogService iAssetsLogService;

    public TableJobServiceImpl(AppConfigFetcher appConfigFetcher, IAssetsLogService iAssetsLogService){
        this.appConfigFetcher = appConfigFetcher;
        this.iAssetsLogService = iAssetsLogService;
    }

    /**
     * 定时器 - assets_log_{yyyyMMdd}
     */
    private ScheduledThreadPoolExecutor createOfAssetsLogJob;

    @Override
    public void createOfAssetsLogJob() {
        if(null != createOfAssetsLogJob){
            return;
        }
        createOfAssetsLogJob = new ScheduledThreadPoolExecutor(1,
                new NamedThreadFactory("createOfAssetsLogJob"));

        createOfAssetsLog(0);
        createOfAssetsLogJob.scheduleWithFixedDelay(() -> {
            createOfAssetsLog(1);
        }, 0, 1, TimeUnit.DAYS);
    }

    private void createOfAssetsLog(int daysToAdd) {
        final String tableName = AssetsLog.getTableName(daysToAdd);
        iAssetsLogService.createTableIfNecessary(appConfigFetcher.databaseName(), tableName);
    }
}
