package com.bxm.game.common.core.prop;

import java.util.Map;

/**
 * 道具
 *
 * @author allen
 * @date 2020-10-14
 * @since 1.0
 */
public interface Prop {

    /**
     * @return 道具对应的资产类型
     */
    String getAssetType();

    /**
     * 是否立即获得道具
     * @return true，立即获得；false，需要二次确认才能获得
     */
    default boolean acquired() {
        return true;
    }

    /**
     * 当 {@link #acquired()} 为 {@code false}时，二次确认领取的时间必须大于这个时间。
     * @return 时间戳，单位：毫秒
     */
    default long startAcquireTime() {
        return System.currentTimeMillis();
    }

    /**
     * 在此时间前还未二次确认领取，那么将过期不能再领取。
     * @return 时间戳，单位：毫秒。0 表示不过期。
     */
    default long endAcquireTime() {
        return 0;
    }

    /**
     * 可翻倍次数
     * @return 默认 1
     */
    default int multipleNum() {
        return 1;
    }

    /**
     * 道具数
     * @return 默认 1
     */
    default int propNum() {
        return 1;
    }

    /**
     * 获取道具的扩展数据，它会保存到 {@link AcquiredPropLog} 记录中。
     * @return
     */
    default Map<String, Object> getExt() {
        return null;
    }
}
