package com.bxm.game.common.core.prop.impl;

import com.bxm.game.common.core.assets.AssetService;
import com.bxm.game.common.core.prop.Prop;
import com.bxm.game.common.core.prop.PropGrantor;
import com.bxm.game.common.core.prop.event.PropGrantEvent;
import com.bxm.warcar.integration.eventbus.SyncEventPark;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;

/**
 * 抽象的道具授予者
 *
 * @author allen
 * @date 2020-11-26
 * @since 1.0
 */
@ConditionalOnMissingBean(PropGrantor.class)
public class DefaultPropGrantorImpl implements PropGrantor {

    private final AssetService assetService;
    private final SyncEventPark syncEventPark;

    public DefaultPropGrantorImpl(AssetService assetService, SyncEventPark syncEventPark) {
        this.assetService = assetService;
        this.syncEventPark = syncEventPark;
    }

    @Override
    public void single(Prop prop) {
        final long after = assetService.plus(prop.getAssetType(), prop.propNum());
        syncEventPark.post(new PropGrantEvent(this, PropGrantEvent.TYPE_SINGLE, prop.getAssetType(), after));
    }

    @Override
    public void multiple(Prop prop) {
        final long after = assetService.plus(prop.getAssetType(), prop.propNum() * prop.multipleNum());
        syncEventPark.post(new PropGrantEvent(this, PropGrantEvent.TYPE_MULTIPLE, prop.getAssetType(), after));
    }
}
