package com.bxm.game.common.core.scene;

import com.bxm.game.common.core.user.TodayAtomicService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;

/**
 * <p>抽象的每天最多可获取的次数的场景实现。</p>
 *
 * <p>默认每天可获取一次，该类重写了 {@link #isAbort(SceneRequest, Map)} 方法。</p>
 *
 * <p>你可以通过重写 {@link #getMaximum()} 来设置每天最多可获取的次数。</p>
 *
 * @author allen
 * @date 2020-12-03
 * @since 1.0
 */
@Slf4j
public abstract class AbstractMaximumTimesOnDailySceneService<R extends SceneRequest, T extends SceneResponse> extends AbstractSceneService<R, T> {

    @Autowired
    protected TodayAtomicService todayAtomicService;

    protected String getAbortedKey() {
        return getSceneType();
    }

    /**
     * 返回每天最多可获取的次数
     * @return 每天最多可获取的次数
     */
    protected int getMaximum() {
        return 1;
    }

    @Override
    protected boolean isAbort(R request, Map<Object, Object> attach) {
        return todayAtomicService.increment(getAbortedKey(), (after) -> after > getMaximum());
    }
}
