package com.bxm.game.common.core.scene.listeners;

import com.bxm.game.common.core.prop.Prop;
import com.bxm.game.common.core.prop.PropGrantor;
import com.bxm.game.common.core.scene.event.AcquiredPropEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

/**
 * 发放道具
 *
 * @author allen
 * @date 2020-10-19
 * @since 1.0
 */
@Slf4j
@Order(Ordered.HIGHEST_PRECEDENCE)
public class GrantPropListener implements EventListener<AcquiredPropEvent> {

    private final PropGrantor grantor;

    public GrantPropListener(PropGrantor grantor) {
        this.grantor = grantor;
    }

    @Override
    @Subscribe
    public void consume(AcquiredPropEvent event) {
        Prop prop = event.getProp();

        if (!prop.acquired()) {
            return;
        }
        if (event.isMultiple() && prop.multipleNum() > 1) {
            grantor.multiple(prop);
        } else {
            grantor.single(prop);
        }
    }
}
