package com.bxm.game.common.core.scene.multiple;

import lombok.Getter;

import java.util.EventObject;

/**
 * 道具通过 {@link com.bxm.game.common.core.scene.SceneType#MULTIPLE} 场景获取后触发的事件。
 *
 * @author allen
 * @date 2020-12-02
 * @since 1.0
 */
@Getter
public class MultipleSceneEvent extends EventObject {

    private final MultipleSceneRequest request;
    private final MultipleSceneResponse response;

    public MultipleSceneEvent(Object source, MultipleSceneRequest request, MultipleSceneResponse response) {
        super(source);
        this.request = request;
        this.response = response;
    }
}
