package com.bxm.game.common.core.user;

import java.util.List;

import com.bxm.game.common.core.vo.GameVo;

/**
 * 最近玩的游戏<br/>
 *
 * @author kerry.jiang
 * @date 2021/4/1 17:25
 */
public interface LatelyGameService {

    /**
     * 标记为最近玩的游戏<br/>
     *
     * @return
     */
    void markLatelyGame();

    /**
     * 获取最近玩的游戏<br/>
     *
     * @param days 最近多少天
     * @param includeSelf 是否包含本游戏
     * @return
     */
    List<GameVo> getLatelyGames(Integer days, Boolean includeSelf);
}
