package com.bxm.game.common.core.user;

import com.bxm.game.common.core.AppConfigFetcher;

/**
 * 用户活跃服务
 *
 * @author allen
 * @date 2021-01-28
 * @since 1.2.4
 */
public interface UserActiveService {

    /**
     * <p>设置用户今天为活跃</p>
     * <p>也可以通过配置来决定在什么情况下会被标记今天为活跃</p>
     * @see AppConfigFetcher#activatingOnFetchArchive()
     * @see com.bxm.game.common.core.scene.listeners.ActiveListener
     */
    void active();

    /**
     * 获取用户活跃天数
     * @return 天数
     */
    long getActiveDays();

    /**
     * 重置用户的活跃天数
     */
    void clean();
}
