package com.bxm.game.common.core.user.dao;

import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;

import com.bxm.game.common.core.AppContext;
import com.bxm.game.common.core.user.DefaultTimeBoundService;
import com.bxm.warcar.utils.DateHelper;

/**
 * 用户<br/>
 *
 * @author kerry.jiang
 * @date 2021/1/20 18:36
 */
@ConditionalOnMissingBean(UserDao.class)
public class EmptyUserDaoImpl implements UserDao {

    @Autowired(required = false)
    protected DefaultTimeBoundService defaultTimeBoundService;

    @Override
    public String getUid(String appid, String device) {
        return device;
    }

    @Override
    public void handleAppContext(AppContext context) {

    }

    /**
     * 填充锚定日期
     *
     * @param context 上下文
     * @param cycleTimes 时效周期（秒）
     * @param format 锚定日期格式
     */
    protected void fillAnchor(AppContext context, int cycleTimes, String format){
        fillAnchor(context, cycleTimes, 300, format);
    }

    /**
     * 填充锚定日期
     *
     * @param context 上下文
     * @param cycleTimes 时效周期（秒）
     * @param delay 时效数据延长过期时长（秒）。</br>
     *              为防止锚定日期未变更，而时效数据已过期的极端情况，适当地延长了时效数据的有效时长。
     * @param format 锚定日期格式
     */
    protected void fillAnchor(AppContext context, int cycleTimes, int delay, String format){
        String boundAnchor = defaultTimeBoundService.saveGetAnchor(cycleTimes,
                (anchor) -> {
                    long limitTime = DateUtils.addSeconds(DateHelper.parse(anchor, format),
                            cycleTimes).getTime();
                    return System.currentTimeMillis() > limitTime;
                },
                ()-> DateHelper.format(format)
        );
        context.setBoundAnchor(boundAnchor);
        long limitTime = DateUtils.addSeconds(DateHelper.parse(boundAnchor, format),
                cycleTimes+delay).getTime();
        context.setBoundLimit(limitTime);
    }

}
