package com.bxm.game.common.core.user.redis;

import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

import org.springframework.beans.factory.annotation.Qualifier;

import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.core.Key;
import com.bxm.game.common.core.user.TodayAtomicService;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;


/**
 * @author allen
 * @date 2020-11-27
 * @since 1.0
 */
public class RedisTodayAtomicServiceImpl implements TodayAtomicService {

    private final AppConfigFetcher appConfigFetcher;
    private final Key key;
    private final Fetcher fetcher;
    private final Updater updater;
    private final Counter counter;

    public RedisTodayAtomicServiceImpl(AppConfigFetcher appConfigFetcher, Key key,
                                       @Qualifier("jedisFetcher") Fetcher fetcher,
                                       @Qualifier("jedisUpdater") Updater updater,
                                       @Qualifier("jedisCounter") Counter counter) {
        this.appConfigFetcher = appConfigFetcher;
        this.key = key;
        this.fetcher = fetcher;
        this.updater = updater;
        this.counter = counter;
    }

    @Override
    public Map<String, Object> getAll() {
        return fetcher.hfetchall(this.key.getTodayDataForUser(appConfigFetcher.todayWithApp()), Object.class);
    }

    @Override
    public long get(String key) {
        return Optional.ofNullable(counter.hget(this.key.getTodayDataForUser(appConfigFetcher.todayWithApp()), key)).orElse(0L);
    }

    @Override
    public long incrementBy(String key, long value) {
        return Optional.ofNullable(counter.hincrementByAndGet(this.key.getTodayDataForUser(appConfigFetcher.todayWithApp()), key, value, Key.EXPIRE_TIME_ONE_DAY)).orElse(0L);
    }

    @Override
    public boolean incrementBy(String key, long value, Predicate<Long> predicate) {
        long l = this.incrementBy(key, value);
        return predicate.test(l);
    }

    @Override
    public void delete(String key) {
        updater.hremove(this.key.getTodayDataForUser(appConfigFetcher.todayWithApp()), key);
    }
}
