package com.bxm.game.common.core.user.redis;

import org.springframework.beans.factory.annotation.Qualifier;

import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.core.Key;
import com.bxm.game.common.core.system.RuntimeClock;
import com.bxm.game.common.core.user.UserActiveService;
import com.bxm.warcar.cache.Fetcher;

import lombok.extern.slf4j.Slf4j;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

/**
 * @author allen
 * @date 2021-01-28
 * @since 1.0
 */
@Slf4j
public class RedisUserActiveServiceImpl implements UserActiveService {

    private final AppConfigFetcher appConfigFetcher;
    private final Key key;
    private final Fetcher fetcher;
    private final RuntimeClock runtimeClock;

    public RedisUserActiveServiceImpl(AppConfigFetcher appConfigFetcher, Key key,
                                      @Qualifier("jedisFetcher") Fetcher fetcher,
                                      RuntimeClock runtimeClock) {
        this.appConfigFetcher = appConfigFetcher;
        this.key = key;
        this.fetcher = fetcher;
        this.runtimeClock = runtimeClock;
    }

    @Override
    public void active() {
        JedisPool jedisPool = getJedisPool();
        try (Jedis jedis = jedisPool.getResource()) {
            jedis.setbit(getKey(), runtimeClock.getRuntimeDays(), true);
        }
    }

    @Override
    public long getActiveDays() {
        JedisPool jedisPool = getJedisPool();
        try (Jedis jedis = jedisPool.getResource()) {
            return jedis.bitcount(getKey());
        }
    }

    @Override
    public void clean() {
        JedisPool pool = getJedisPool();
        try (Jedis jedis = pool.getResource()) {
            jedis.del(getKey());
        }
    }

    private String getKey() {
        return this.key.bitmapActive(appConfigFetcher.activeWithApp()).generateKey();
    }

    private JedisPool getJedisPool() {
        final Object original = fetcher.getClientOriginal();
        if (!(original instanceof JedisPool)) {
            throw new RuntimeException("originalClient is not JedisPool!");
        }
        return (JedisPool) original;
    }
}
