package com.bxm.game.common.core.vo;

import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 存档
 *
 * @author allen
 * @date 2020-10-19
 * @since 1.0
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ArchiveVo {

    /**
     * 今日数据
     */
    private Map<String, Object> today;
    /**
     * 时效数据
     */
    private Map<String, Object> bound;
    /**
     * 永久数据
     */
    private Map<String, Object> permanent;
    /**
     * 资产
     */
    private Map<String, Object> assets;
    /**
     * 自定义
     */
    private Map<String, Object> custom;
    /**
     * 连续签到天数
     */
    private Integer continuousSignInDays;
    /**
     * 活跃天数
     */
    private Long activeDays;
    /**
     * 服务器时间
     */
    private long time;
}
