package com.bxm.game.common.core.withdraw.dao;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bxm.game.common.core.withdraw.WithdrawRequest;
import com.bxm.game.common.core.withdraw.WithdrawResponse;
import com.bxm.game.common.dal.entity.PrizeLog;

/**
 * 提现服务扩展<br/>
 *
 * @author kerry.jiang
 * @date 2021/3/23 17:23
 */
public interface WithdrawDao {

    /**
     * 校验提现条件
     *
     * @param request 提现信息
     * @param attach 附件,用于内部参数传递
     * @return true: 可以提现
     */
    boolean check(WithdrawRequest request, Map<Object, Object> attach);

    /**
     * 执行扣款
     *
     * @param request 提现信息
     * @param attach 附件,用于内部参数传递
     */
    void deduct(WithdrawRequest request, Map<Object, Object> attach);

    /**
     * 回滚扣款
     *
     * @param request 提现信息
     * @param attach 附件,用于内部参数传递
     */
    void rollback(WithdrawRequest request, Map<Object, Object> attach);

    /**
     * 提现金额转元,用于标题
     *
     * @param request 提现信息
     * @param attach 附件,用于内部参数传递
     * @return
     */
    Double toYuan(WithdrawRequest request, Map<Object, Object> attach);

    /**
     * 提现记录保存前,处理提现记录<br/>
     *
     * @param prizeLog 提现记录
     * @param attach 附件,用于内部参数传递
     */
    default void handlePrizeLog(PrizeLog prizeLog, Map<Object, Object> attach){

    }

    /**
     * 获取提现记录的查询条件<br/>
     *
     * @return
     */
    default QueryWrapper<PrizeLog> getQuery(){
        return null;
    }

    /**
     * 获取提现记录的查询结果<br/>
     *
     * @param logList
     * @return
     */
    default List<WithdrawResponse> getResponse(List<PrizeLog> logList){
        return logList.stream().map((e) -> {
            return new WithdrawResponse()
                    .setId(e.getId())
                    .setOrderId(e.getOrderId())
                    .setAppId(e.getAppId())
                    .setUid(e.getUid())
                    .setStatus(e.getStatus())
                    .setCreateTime(e.getCreateTime())
                    .setName(e.getName())
                    .setMobile(e.getMobile())
                    .setPayType(e.getPayType())
                    .setAccount(e.getAccount())
                    .setAmount(e.getAmount())
                    ;
        }).collect(Collectors.toList());
    }
}
