/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core;

import com.bxm.game.common.core.AppConfig;
import com.bxm.game.common.core.AppContext;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;

public final class Key {
    public static final int EXPIRE_TIME_TEN_MINUTES = 600;
    public static final int EXPIRE_TIME_ONE_DAY = 86400;
    private final AppConfig appConfig;

    public Key(AppConfig appConfig) {
        this.appConfig = appConfig;
    }

    public KeyGenerator generator(String ... keys) {
        return this.generator(true, keys);
    }

    public KeyGenerator generator(boolean onNamespace, String ... keys) {
        ArrayList list = Lists.newArrayList((Object[])new Object[]{"game"});
        if (onNamespace) {
            list.add(this.appConfig.getNamespace());
        }
        list.addAll(Arrays.asList(keys));
        return () -> KeyBuilder.build((Object[])list.toArray(new Object[0]));
    }

    public KeyGenerator getUserAsset() {
        return this.getUserAsset(true);
    }

    public KeyGenerator getUserAsset(boolean withApp) {
        ArrayList list = Lists.newArrayList((Object[])new Object[]{"game", this.appConfig.getNamespace(), "assets"});
        if (withApp) {
            list.add(AppContext.get().getAppId());
        }
        list.add(AppContext.get().getUid());
        return () -> KeyBuilder.build((Object[])list.toArray(new Object[0]));
    }

    public KeyGenerator getPermanentDataForUser() {
        return this.getPermanentDataForUser(true);
    }

    public KeyGenerator getPermanentDataForUser(boolean withApp) {
        ArrayList list = Lists.newArrayList((Object[])new Object[]{"game", this.appConfig.getNamespace(), "user", "0"});
        if (withApp) {
            list.add(AppContext.get().getAppId());
        }
        list.add(AppContext.get().getUid());
        return () -> KeyBuilder.build((Object[])list.toArray(new Object[0]));
    }

    public KeyGenerator getTodayDataForUser() {
        return this.getTodayDataForUser(true);
    }

    public KeyGenerator getTodayDataForUser(boolean withApp) {
        ArrayList list = Lists.newArrayList((Object[])new Object[]{"game", this.appConfig.getNamespace(), "user", DateHelper.getDate()});
        if (withApp) {
            list.add(AppContext.get().getAppId());
        }
        list.add(AppContext.get().getUid());
        return () -> KeyBuilder.build((Object[])list.toArray(new Object[0]));
    }

    public KeyGenerator getTemporary() {
        return this.getTemporary(true);
    }

    public KeyGenerator getTemporary(boolean withApp) {
        ArrayList list = Lists.newArrayList((Object[])new Object[]{"game", this.appConfig.getNamespace(), "temporary"});
        if (withApp) {
            list.add(AppContext.get().getAppId());
        }
        list.add(AppContext.get().getUid());
        return () -> KeyBuilder.build((Object[])list.toArray(new Object[0]));
    }

    public KeyGenerator getTimeBound(String anchor, String type) {
        return this.getTimeBound(anchor, type, true);
    }

    public KeyGenerator getTimeBound(String anchor, String type, boolean withApp) {
        ArrayList list = Lists.newArrayList((Object[])new Object[]{"game", this.appConfig.getNamespace(), "bound"});
        if (null != anchor) {
            list.add(anchor);
        }
        if (withApp) {
            list.add(AppContext.get().getAppId());
        }
        list.add(AppContext.get().getUid());
        list.add(type);
        return () -> KeyBuilder.build((Object[])list.toArray(new Object[0]));
    }

    public KeyGenerator bitmapActive(boolean withApp) {
        ArrayList list = Lists.newArrayList((Object[])new Object[]{"game", this.appConfig.getNamespace(), "active"});
        if (withApp) {
            list.add(AppContext.get().getAppId());
        }
        list.add(AppContext.get().getUid());
        return () -> KeyBuilder.build((Object[])list.toArray(new Object[0]));
    }

    public KeyGenerator getSignin() {
        return () -> KeyBuilder.build((Object[])new Object[]{"game", this.appConfig.getNamespace(), "signin", "times", AppContext.get().getAppId(), AppContext.get().getUid()});
    }

    public KeyGenerator getTodayDataForApp() {
        return () -> KeyBuilder.build((Object[])new Object[]{"game", this.appConfig.getNamespace(), "app", DateHelper.getDate(), AppContext.get().getAppId()});
    }

    public KeyGenerator getJobLock(String jobName) {
        return () -> KeyBuilder.build((Object[])new Object[]{"game", this.appConfig.getNamespace(), "lock", jobName});
    }

    public KeyGenerator getLatelyGames() {
        ArrayList list = Lists.newArrayList((Object[])new Object[]{"game", "common", "lately"});
        list.add(AppContext.get().getAppId());
        list.add(AppContext.get().getDevUid());
        return () -> KeyBuilder.build((Object[])list.toArray(new Object[0]));
    }

    public KeyGenerator getGameAll() {
        return () -> KeyBuilder.build((Object[])new Object[]{"game", "common", "all"});
    }
}

