/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.activity.dao;

import com.bxm.game.common.core.AppConfig;
import com.bxm.game.common.core.ErrCode;
import com.bxm.game.common.core.GameException;
import com.bxm.game.common.core.activity.ActivityConfig;
import com.bxm.game.common.core.activity.dao.ActivityCachingConfig;
import com.bxm.game.common.core.activity.dao.ActivityDao;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Qualifier;

public class DefaultActivityDaoImpl
implements ActivityDao {
    private final AppConfig appConfig;
    private final Fetcher fetcher;

    public DefaultActivityDaoImpl(AppConfig appConfig, @Qualifier(value="jedisFetcher") Fetcher fetcher) {
        this.appConfig = appConfig;
        this.fetcher = fetcher;
    }

    @Override
    public ActivityConfig get(String appId) {
        ActivityCachingConfig caching = this.getCaching(appId);
        if (Objects.isNull(caching) && Objects.isNull(caching = this.getCaching("default"))) {
            throw new GameException(ErrCode.CONFIG_INVALID);
        }
        ActivityConfig.ActivityConfigBuilder builder = ActivityConfig.builder();
        builder.appId(caching.getAppId());
        builder.title(caching.getTitle());
        builder.config(caching.getConfig());
        return builder.build();
    }

    @Override
    public <T> T getConfig(String appId, Class<T> clazz) {
        T config = this.getConfig0(appId, clazz);
        if (Objects.isNull(config) && Objects.isNull(config = this.getConfig0("default", clazz))) {
            throw new GameException(ErrCode.CONFIG_INVALID);
        }
        return config;
    }

    private ActivityCachingConfig getCaching(String appId) {
        return (ActivityCachingConfig)this.fetcher.hfetch(this.hash(), appId, ActivityCachingConfig.class);
    }

    private <T> T getConfig0(String appId, Class<T> clazz) {
        return (T)this.fetcher.hfetch(this.hash(), appId, clazz);
    }

    private KeyGenerator hash() {
        return () -> KeyBuilder.build((Object[])new Object[]{"game", this.appConfig.getNamespace(), "config"});
    }
}

