/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.archives.redis;

import com.bxm.game.common.core.archives.CustomArchive;
import com.bxm.game.common.core.archives.CustomArchiveDataService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Qualifier;

public class RedisCustomArchiveDataServiceImpl
implements CustomArchiveDataService {
    private final Fetcher fetcher;
    private final Updater updater;

    public RedisCustomArchiveDataServiceImpl(@Qualifier(value="jedisFetcher") Fetcher fetcher, @Qualifier(value="jedisUpdater") Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public void hset(CustomArchive archive) {
        this.updater.hupdate(archive::getKey, archive.getField(), archive.getValue(), archive.getExpireTimeInSeconds());
    }

    @Override
    public void hdel(String key, String field) {
        this.updater.hremove(() -> key, new String[]{field});
    }

    @Override
    public <T> Collection<T> hgetAll(String key, Class<T> clazz) {
        Map map = this.fetcher.hfetchall(() -> key, clazz);
        if (MapUtils.isNotEmpty((Map)map)) {
            return map.values();
        }
        return null;
    }
}

