/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.assets;

import com.bxm.game.common.core.assets.AssetService;
import com.bxm.game.common.core.user.DefaultTimeBoundService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultTimeBoundAssetServiceImpl
implements AssetService {
    private static final Logger log = LoggerFactory.getLogger(DefaultTimeBoundAssetServiceImpl.class);
    private final String BOUND_ASSET = "asset";
    @Autowired(required=false)
    protected DefaultTimeBoundService defaultTimeBoundService;

    @Override
    public long plus(String type, long value) {
        return this.defaultTimeBoundService.hIncrBy("asset", type, value);
    }

    @Override
    public long minus(String type, long value) {
        return this.defaultTimeBoundService.hIncrBy("asset", type, -value);
    }

    @Override
    public long get(String type) {
        return this.defaultTimeBoundService.hGet("asset", type);
    }

    @Override
    public long get(String type, long defaultValue) {
        return this.defaultTimeBoundService.hGet("asset", type, defaultValue);
    }

    @Override
    public void set(String type, long value) {
        this.defaultTimeBoundService.hSet("asset", type, String.valueOf(value));
    }

    @Override
    public void delete(String type) {
        this.defaultTimeBoundService.hDel("asset", type);
    }

    @Override
    public Map<String, Object> getAll() {
        HashMap<String, Object> rst = new HashMap<String, Object>();
        Map<String, String> map = this.defaultTimeBoundService.hGetAll("asset", String.class);
        if (MapUtils.isEmpty(map)) {
            return rst;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (NumberUtils.isCreatable((String)value)) {
                rst.put(key, NumberUtils.toInt((String)value));
                continue;
            }
            rst.put(key, value);
        }
        return rst;
    }
}

