/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.assets.dao;

import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.core.Key;
import com.bxm.game.common.core.assets.dao.AssetDao;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class RedisAssetDaoImpl
implements AssetDao {
    private final AppConfigFetcher appConfigFetcher;
    private final Fetcher fetcher;
    private final Counter counter;
    private final Updater updater;
    private final Key key;

    public RedisAssetDaoImpl(AppConfigFetcher appConfigFetcher, Fetcher fetcher, Counter counter, Updater updater, Key key) {
        this.appConfigFetcher = appConfigFetcher;
        this.fetcher = fetcher;
        this.counter = counter;
        this.updater = updater;
        this.key = key;
    }

    @Override
    public long plus(String type, long value) {
        return this.counter.hincrementByAndGet(this.key.getUserAsset(this.appConfigFetcher.assetWithApp()), type, value);
    }

    @Override
    public long minus(String type, long value) {
        return this.counter.hincrementByAndGet(this.key.getUserAsset(this.appConfigFetcher.assetWithApp()), type, -value);
    }

    @Override
    public long get(String type) {
        return this.get(type, 0L);
    }

    @Override
    public long get(String type, long defaultValue) {
        return (Long)Optional.ofNullable(this.fetcher.hfetch(this.key.getUserAsset(this.appConfigFetcher.assetWithApp()), type, Long.class)).orElse(defaultValue);
    }

    @Override
    public void set(String type, long value) {
        this.updater.hupdate(this.key.getUserAsset(this.appConfigFetcher.assetWithApp()), type, (Object)value);
    }

    @Override
    public void delete(String type) {
        this.updater.hremove(this.key.getUserAsset(this.appConfigFetcher.assetWithApp()), new String[]{type});
    }

    @Override
    public Map<String, Object> getAll() {
        HashMap<String, Object> rst = new HashMap<String, Object>();
        Map map = this.fetcher.hfetchall(this.key.getUserAsset(this.appConfigFetcher.assetWithApp()), String.class);
        if (MapUtils.isEmpty((Map)map)) {
            return rst;
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (NumberUtils.isCreatable((String)value)) {
                rst.put(key, NumberUtils.toInt((String)value));
                continue;
            }
            rst.put(key, value);
        }
        return rst;
    }
}

