/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.autoconfigure;

import com.bxm.game.common.core.autoconfigure.config.CommonRedisConfig;
import com.bxm.warcar.cache.impls.redis.JedisCounter;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import redis.clients.jedis.JedisPool;

@EnableConfigurationProperties(value={CommonRedisConfig.class})
@ConditionalOnProperty(name={"game.common.jedis.host"})
public class CommonRedisAutoConfiguration {
    private final CommonRedisConfig commonRedisConfig;

    public CommonRedisAutoConfiguration(CommonRedisConfig commonRedisConfig) {
        this.commonRedisConfig = commonRedisConfig;
    }

    @Bean
    public JedisPool commonPool() {
        return new JedisPool((GenericObjectPoolConfig)this.commonRedisConfig, this.commonRedisConfig.getHost(), this.commonRedisConfig.getPort(), this.commonRedisConfig.getTimeout(), this.commonRedisConfig.getPassword(), this.commonRedisConfig.getDatabase());
    }

    @Bean
    public JedisFetcher commonFetcher(@Qualifier(value="commonPool") JedisPool commonPool) {
        return new JedisFetcher(commonPool);
    }

    @Bean
    public JedisUpdater commonUpdater(@Qualifier(value="commonPool") JedisPool commonPool) {
        return new JedisUpdater(commonPool);
    }

    @Bean
    public JedisCounter commonCounter(@Qualifier(value="commonPool") JedisPool commonPool) {
        return new JedisCounter(commonPool);
    }
}

