/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.controllers;

import com.bxm.game.common.core.scene.SceneResponse;
import com.bxm.game.common.core.scene.SceneService;
import com.bxm.game.common.core.scene.SceneServiceFactory;
import java.util.Objects;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/scene"})
public class SceneController {
    private final SceneServiceFactory factory;

    public SceneController(SceneServiceFactory factory) {
        this.factory = factory;
    }

    @PostMapping(value={"/take/{sceneType}"})
    public ResponseEntity<SceneResponse> take(@PathVariable(value="sceneType") String sceneType, @RequestBody(required=false) String message) {
        SceneService service = this.factory.get(sceneType);
        if (Objects.isNull(service)) {
            return ResponseEntity.badRequest().build();
        }
        Object request = service.convert(message);
        Object response = service.take(request);
        return ResponseEntity.ok(response);
    }
}

