/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.interceptor;

import com.bxm.game.common.core.AppContext;
import com.bxm.game.common.core.RequestHeaderHandler;
import com.bxm.game.common.core.user.dao.UserDao;
import com.bxm.warcar.integration.dc.dot.Device;
import com.bxm.warcar.utils.JsonHelper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerInterceptor;

public class AppContextInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AppContextInterceptor.class);
    private final UserDao userDao;
    private final RequestHeaderHandler requestHeaderHandler;

    public AppContextInterceptor(UserDao userDao, RequestHeaderHandler requestHeaderHandler) {
        this.userDao = userDao;
        this.requestHeaderHandler = requestHeaderHandler;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String uid;
        String appid = request.getHeader("x-appid");
        String device = request.getHeader("x-device");
        String did = request.getHeader("x-did");
        if (StringUtils.isBlank((String)appid) || StringUtils.isBlank((String)device)) {
            log.info("Required header name: 'appid' and 'device' is blank!");
            response.setStatus(HttpStatus.ACCEPTED.value());
            return false;
        }
        AppContext context = AppContext.getInstance();
        if (StringUtils.isNotBlank((String)did)) {
            Device deviceObject = Device.decrypt((String)did);
            context.setDevice(deviceObject);
            if (this.requestHeaderHandler.isOverrideDeviceValue(appid, device, deviceObject)) {
                String newDevice = this.requestHeaderHandler.fetchDeviceValue(deviceObject);
                if (!StringUtils.equals((String)newDevice, (String)device)) {
                    log.warn("{} Not equals, device is:{}, except: {}, but: {}", new Object[]{appid, JsonHelper.convert((Object)deviceObject), device, newDevice});
                }
                if (StringUtils.isNotBlank((String)newDevice)) {
                    device = newDevice;
                }
            }
        }
        if (StringUtils.isBlank((String)(uid = this.userDao.getUid(appid, device)))) {
            log.info("uid is blank,appid={},device={}", (Object)appid, (Object)device);
            response.setStatus(HttpStatus.ACCEPTED.value());
            return false;
        }
        context.setAppId(appid).setDevUid(device).setUid(uid).setDid(did);
        this.userDao.handleAppContext(context);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        AppContext.remove();
    }
}

