/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.job;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bxm.game.common.core.AppConfig;
import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.core.Consts;
import com.bxm.game.common.core.Key;
import com.bxm.game.common.core.job.AssetJobService;
import com.bxm.game.common.dal.entity.AssetsSnapshot;
import com.bxm.game.common.dal.service.IAssetsSnapshotService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.RedisLock;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public class AssetJobServiceImpl
implements AssetJobService {
    private static final Logger log = LoggerFactory.getLogger(AssetJobServiceImpl.class);
    private final Fetcher fetcher;
    private final AppConfig appConfig;
    private final AppConfigFetcher appConfigFetcher;
    private final IAssetsSnapshotService iAssetsSnapshotService;
    private final Key key;
    private final RedisLock redisLock;
    private String synAssetJobName = "synAsset";
    private int synAssetJobLockTimes = 300000;

    public AssetJobServiceImpl(@Qualifier(value="jedisFetcher") Fetcher fetcher, AppConfig appConfig, AppConfigFetcher appConfigFetcher, IAssetsSnapshotService iAssetsSnapshotService, Key key, @Qualifier(value="distributedRedisLock") RedisLock redisLock) {
        this.fetcher = fetcher;
        this.appConfig = appConfig;
        this.appConfigFetcher = appConfigFetcher;
        this.iAssetsSnapshotService = iAssetsSnapshotService;
        this.key = key;
        this.redisLock = redisLock;
    }

    @Override
    public void synAsset(Integer lockTimes) {
        int expireTime = null != lockTimes ? lockTimes : this.synAssetJobLockTimes;
        String lockKey = this.key.getJobLock(this.synAssetJobName).generateKey();
        boolean isLock = this.redisLock.tryLock(lockKey, this.synAssetJobName, expireTime);
        if (!isLock) {
            throw new RuntimeException("\u8bf7\u52ff\u9891\u7e41\u64cd\u4f5c");
        }
        new Thread(() -> {
            try {
                this.synAsset0();
            }
            catch (Exception e) {
                log.error("synAsset error:", (Throwable)e);
            }
            finally {
                this.redisLock.unLock(lockKey, this.synAssetJobName);
            }
        }).start();
    }

    private void synAsset0() {
        boolean isSynAppUid = this.appConfigFetcher.isSynAppUid();
        List<String> assetTypes = this.appConfigFetcher.synAssetTypes();
        if (CollectionUtils.isEmpty(assetTypes)) {
            return;
        }
        LocalDateTime currentDate = LocalDateTime.now();
        String rptDate = DateHelper.format((String)"yyyyMMdd");
        String pattern = "*game:" + this.appConfig.getNamespace() + ":assets:*:*";
        QueryWrapper query = Wrappers.query((Object)new AssetsSnapshot().setRptDate(rptDate).setActivityType(this.appConfigFetcher.activityType()));
        this.iAssetsSnapshotService.remove((Wrapper)query);
        try (Jedis jedis = this.getJedisPool().getResource();){
            String startCursor = "0";
            String cursor = "0";
            AtomicLong index = new AtomicLong();
            int count = 10000;
            ScanParams params = new ScanParams().match(pattern).count(Integer.valueOf(10000));
            ArrayList snapshots = Lists.newArrayList();
            HashMap snapshotMap = isSynAppUid ? Maps.newHashMap() : null;
            do {
                ScanResult scanResult = jedis.scan(cursor, params);
                cursor = scanResult.getStringCursor();
                List result = scanResult.getResult();
                if (CollectionUtils.isEmpty((Collection)result)) continue;
                for (String k : result) {
                    this.fillSnapshot(currentDate, rptDate, snapshots, snapshotMap, k, assetTypes);
                    if (null != snapshotMap) {
                        this.fillAppUid(snapshotMap);
                    }
                    if (snapshots.size() <= 199) continue;
                    this.iAssetsSnapshotService.saveBatch((Collection)snapshots);
                    snapshots = new ArrayList();
                    if (null != snapshotMap) {
                        snapshotMap.clear();
                    }
                    currentDate = LocalDateTime.now();
                }
                log.info("index={} | cursor={} success insert to db: {}", new Object[]{index.addAndGet(10000L), cursor, snapshots.size()});
            } while (!cursor.equals("0"));
            if (snapshots.size() > 0) {
                this.iAssetsSnapshotService.saveBatch((Collection)snapshots);
            }
        }
    }

    private void fillSnapshot(LocalDateTime currentDate, String rptDate, List<AssetsSnapshot> snapshots, Map<String, AssetsSnapshot> snapshotMap, String k, List<String> assetTypes) {
        Map map = this.fetcher.hfetchall(() -> k, String.class);
        Matcher m = Consts.PATTERN_ASSET.matcher(k);
        if (!m.find()) {
            return;
        }
        String appid = m.group(1);
        String uid = m.group(2);
        AssetsSnapshot snapshot = new AssetsSnapshot();
        for (String assetType : assetTypes) {
            Integer assetNum = Integer.valueOf(map.getOrDefault(assetType, "0"));
            snapshot.setRptDate(rptDate);
            snapshot.setAppId(appid);
            snapshot.setUid(uid);
            snapshot.setAppUid("");
            snapshot.setActivityType(this.appConfigFetcher.activityType());
            snapshot.setAssetType(assetType);
            snapshot.setAssetNum(assetNum);
            snapshot.setCreateTime(currentDate);
            snapshots.add(snapshot);
            if (null == snapshotMap) continue;
            snapshotMap.put(k, snapshot);
        }
    }

    private void fillAppUid(Map<String, AssetsSnapshot> snapshotMap) {
        HashMap<String, Response> mapUserRs = new HashMap<String, Response>();
        Set<String> keys = snapshotMap.keySet();
        try (Jedis jedis = this.getJedisPool().getResource();){
            jedis.select(1);
            Pipeline pipeline = jedis.pipelined();
            for (String key : keys) {
                AssetsSnapshot snapshot = snapshotMap.get(key);
                mapUserRs.put(key, pipeline.hget(KeyBuilder.build((Object[])new Object[]{"ADX", "USERMAPPING", snapshot.getAppId()}), snapshot.getUid()));
            }
            pipeline.syncAndReturnAll();
        }
        for (String key : keys) {
            String appUid;
            Response rs = (Response)mapUserRs.get(key);
            if (null == rs || null == (appUid = (String)rs.get())) continue;
            snapshotMap.get(key).setAppUid(appUid);
        }
    }

    private JedisPool getJedisPool() {
        Object original = this.fetcher.getClientOriginal();
        if (!(original instanceof JedisPool)) {
            throw new RuntimeException("originalClient is not JedisPool!");
        }
        return (JedisPool)original;
    }
}

