/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.prop.impl;

import com.bxm.game.common.core.assets.AssetService;
import com.bxm.game.common.core.prop.Prop;
import com.bxm.game.common.core.prop.PropGrantor;
import com.bxm.game.common.core.prop.event.PropGrantEvent;
import com.bxm.warcar.integration.eventbus.SyncEventPark;
import java.util.EventObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;

@ConditionalOnMissingBean(value={PropGrantor.class})
public class DefaultPropGrantorImpl
implements PropGrantor {
    private final AssetService assetService;
    private final SyncEventPark syncEventPark;

    public DefaultPropGrantorImpl(AssetService assetService, SyncEventPark syncEventPark) {
        this.assetService = assetService;
        this.syncEventPark = syncEventPark;
    }

    @Override
    public void single(Prop prop) {
        long after = this.assetService.plus(prop.getAssetType(), prop.propNum());
        this.syncEventPark.post((EventObject)new PropGrantEvent(this, 1, prop.getAssetType(), after));
    }

    @Override
    public void multiple(Prop prop) {
        long after = this.assetService.plus(prop.getAssetType(), prop.propNum() * prop.multipleNum());
        this.syncEventPark.post((EventObject)new PropGrantEvent(this, 2, prop.getAssetType(), after));
    }
}

