/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.scene;

import com.bxm.game.common.core.ErrCode;
import com.bxm.game.common.core.GameException;
import com.bxm.game.common.core.prop.Prop;
import com.bxm.game.common.core.scene.SceneRequest;
import com.bxm.game.common.core.scene.SceneResponse;
import com.bxm.game.common.core.scene.SceneService;
import com.bxm.game.common.core.scene.event.AcquiredPropEvent;
import com.bxm.warcar.id.IdGenerator;
import com.bxm.warcar.integration.eventbus.SyncEventPark;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSceneService<R extends SceneRequest, T extends SceneResponse>
implements SceneService<R, T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSceneService.class);
    @Autowired
    private IdGenerator id;
    @Autowired
    private SyncEventPark syncEventPark;

    protected boolean isRequiredRequest() {
        return false;
    }

    protected boolean isAbort(R request, Map<Object, Object> attach) {
        return false;
    }

    protected String createId(R request) {
        return this.id.next();
    }

    protected abstract Prop takeProp(R var1, Map<Object, Object> var2);

    protected abstract T createResponse(R var1, String var2, Prop var3, Map<Object, Object> var4);

    protected void afterAbort(R request) {
    }

    protected void afterTake(R request, Prop prop) {
    }

    protected void beforePostEvent(R request, T response, Prop prop, Map<Object, Object> attach) {
    }

    protected void afterCompletion(R request, T response, Prop prop, Map<Object, Object> attach) {
    }

    @Override
    public T take(R request) {
        if (this.isRequiredRequest() && Objects.isNull(request)) {
            throw new GameException(ErrCode.BAD_REQUEST);
        }
        HashMap attach = Maps.newHashMap();
        if (this.isAbort(request, attach)) {
            this.afterAbort(request);
            return null;
        }
        Prop prop = this.takeProp(request, attach);
        if (Objects.isNull(prop)) {
            return null;
        }
        this.afterTake(request, prop);
        String id = this.createId(request);
        T response = this.createResponse(request, id, prop, attach);
        if (Objects.isNull(response)) {
            log.error("{} createResponse is null", this.getClass());
            throw new GameException(ErrCode.INTERNAL_SERVER_ERROR);
        }
        ((SceneResponse)response).setId(id);
        ((SceneResponse)response).setAssetType(prop.getAssetType());
        ((SceneResponse)response).setPropNum(prop.propNum());
        ((SceneResponse)response).setAcquired(prop.acquired());
        ((SceneResponse)response).setMultipleNum(prop.multipleNum());
        ((SceneResponse)response).setStartAcquireTime(prop.startAcquireTime());
        ((SceneResponse)response).setEndAcquireTime(prop.endAcquireTime());
        this.beforePostEvent(request, response, prop, attach);
        this.syncEventPark.post((EventObject)new AcquiredPropEvent(this, id, this.getSceneType(), prop, this.isMultipleGrant(), attach, (SceneRequest)request, (SceneResponse)response));
        this.afterCompletion(request, response, prop, attach);
        return response;
    }

    @Override
    public R convert(String message) {
        if (StringUtils.isBlank((String)message)) {
            return null;
        }
        return (R)((SceneRequest)JsonHelper.convert((String)message, this.getRequestClass()));
    }

    protected SyncEventPark getSyncEventPark() {
        return this.syncEventPark;
    }
}

