/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.scene.listeners;

import com.bxm.game.common.core.AppContext;
import com.bxm.game.common.core.prop.AcquiredPropLog;
import com.bxm.game.common.core.prop.Prop;
import com.bxm.game.common.core.prop.PropService;
import com.bxm.game.common.core.scene.event.AcquiredPropEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
public class AcquiredPropLogListener
implements EventListener<AcquiredPropEvent> {
    private static final Logger log = LoggerFactory.getLogger(AcquiredPropLogListener.class);
    private final PropService propService;

    public AcquiredPropLogListener(PropService propService) {
        this.propService = propService;
    }

    @Subscribe
    public void consume(AcquiredPropEvent event) {
        Prop prop = event.getProp();
        AcquiredPropLog takePropLog = new AcquiredPropLog();
        takePropLog.setAssetType(prop.getAssetType()).setSceneType(event.getSceneType()).setId(event.getId()).setAppId(AppContext.get().getAppId()).setUid(AppContext.get().getUid()).setPropNum(prop.propNum()).setMultipleNum(prop.multipleNum()).setCompletedMultiple(false).setAcquired(prop.acquired()).setStartAcquireTime(prop.startAcquireTime()).setEndAcquireTime(prop.endAcquireTime()).setExt(prop.getExt());
        AcquiredPropLog source = this.propService.getTakeLog(event.getId());
        if (Objects.nonNull(source)) {
            takePropLog.setSource(source);
        }
        if (log.isDebugEnabled()) {
            log.debug("--- \u4fdd\u5b58\u83b7\u5f97\u9053\u5177\u8bb0\u5f55\uff1a{}", (Object)takePropLog.toString());
        }
        if (!this.propService.saveTakeLog(takePropLog)) {
            log.warn("save take log fail!\n{}", (Object)takePropLog);
        }
    }
}

