/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.scene.signin;

import com.alibaba.fastjson.util.TypeUtils;
import com.bxm.game.common.core.Key;
import com.bxm.game.common.core.prop.Prop;
import com.bxm.game.common.core.scene.AbstractMaximumTimesOnDailySceneService;
import com.bxm.game.common.core.scene.signin.SigninConfig;
import com.bxm.game.common.core.scene.signin.SigninSceneRequest;
import com.bxm.game.common.core.scene.signin.SigninSceneResponse;
import com.bxm.game.common.core.scene.signin.SigninService;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.TypeHelper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@ConditionalOnBean(value={SigninConfig.class})
public class SigninSceneServiceImpl
extends AbstractMaximumTimesOnDailySceneService<SigninSceneRequest, SigninSceneResponse>
implements SigninService {
    private static final Logger log = LoggerFactory.getLogger(SigninSceneServiceImpl.class);
    private final Key key;
    private final SigninConfig signinConfig;
    private final Counter counter;

    public SigninSceneServiceImpl(Key key, SigninConfig signinConfig, @Qualifier(value="jedisCounter") Counter counter) {
        this.key = key;
        this.signinConfig = signinConfig;
        this.counter = counter;
    }

    @Override
    public int getContinuousSignInTimes() {
        return TypeHelper.castToInt((Object)Optional.ofNullable(this.counter.get(this.key.getSignin())).orElse(0L));
    }

    @Override
    protected Prop takeProp(SigninSceneRequest request, Map<Object, Object> attach) {
        KeyGenerator keyGenerator = this.key.getSignin();
        long times = Optional.ofNullable(this.counter.incrementAndGet(keyGenerator)).orElse(1L);
        if (times >= 7L) {
            this.counter.decrementByAndGet(keyGenerator, times);
        }
        this.expireAtTomorrow(keyGenerator.generateKey());
        Map<Integer, Prop> signinProps = this.signinConfig.getSigninProps();
        attach.put("days", times);
        return signinProps.get(TypeUtils.castToInt((Object)times));
    }

    @Override
    protected SigninSceneResponse createResponse(SigninSceneRequest request, String id, Prop prop, Map<Object, Object> attach) {
        SigninSceneResponse response = new SigninSceneResponse();
        response.setDays(NumberUtils.toInt((String)Objects.toString(attach.get("days"))));
        return response;
    }

    @Override
    public String getSceneType() {
        return "signin";
    }

    @Override
    public Class<SigninSceneRequest> getRequestClass() {
        return SigninSceneRequest.class;
    }

    private void expireAtTomorrow(String key) {
        Object clientOriginal = this.counter.getClientOriginal();
        if (clientOriginal instanceof JedisPool) {
            JedisPool jedisPool = (JedisPool)clientOriginal;
            try (Jedis jedis = jedisPool.getResource();){
                Long at = jedis.expireAt(key, this.getAfterTomorrowInMillis() / 1000L);
                if (Optional.ofNullable(at).orElse(0L) == 0L) {
                    log.warn("{} expireAt command execute fail!", (Object)key);
                }
            }
        }
    }

    private long getAfterTomorrowInMillis() {
        LocalDate now = LocalDate.now();
        LocalDate tomorrow = now.plusDays(2L);
        LocalDateTime time = LocalDateTime.of(tomorrow, LocalTime.of(0, 0));
        return time.toInstant(ZoneOffset.of("+8")).toEpochMilli();
    }
}

