/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.system;

import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.core.ErrCode;
import com.bxm.game.common.core.GameException;
import com.bxm.game.common.core.system.RuntimeClock;
import com.bxm.warcar.integration.pair.MutablePair;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class LocalDateRuntimeClockImpl
implements RuntimeClock,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(LocalDateRuntimeClockImpl.class);
    private final MutablePair mutablePair;
    private final AppConfigFetcher appConfigFetcher;

    public LocalDateRuntimeClockImpl(MutablePair mutablePair, AppConfigFetcher appConfigFetcher) {
        this.mutablePair = mutablePair;
        this.appConfigFetcher = appConfigFetcher;
    }

    public void afterPropertiesSet() {
        long runtimeDays;
        String value = this.mutablePair.get(this.getKey()).of();
        if (StringUtils.isBlank((CharSequence)value)) {
            this.initStartingDate();
        }
        if ((runtimeDays = this.getRuntimeDays()) < 0L) {
            throw new RuntimeException("\u7cfb\u7edf\u4e0a\u7ebf\u5929\u6570\u4e0d\u80fd\u5c0f\u4e8e 0\uff0c\u5f53\u524d\uff1a" + runtimeDays);
        }
        log.info("{} \u7cfb\u7edf\u5df2\u4e0a\u7ebf {} \u5929", (Object)this.appConfigFetcher.namespace(), (Object)runtimeDays);
    }

    @Override
    public long getRuntimeDays() {
        String value = this.mutablePair.get(this.getKey()).of();
        if (StringUtils.isBlank((CharSequence)value)) {
            this.initStartingDate();
        }
        try {
            LocalDate now = LocalDate.now();
            LocalDate firstDay = LocalDate.parse(value, DateTimeFormatter.ofPattern("yyyyMMdd"));
            return now.toEpochDay() - firstDay.toEpochDay();
        }
        catch (DateTimeParseException e) {
            log.error("parse: ", (Throwable)e);
            throw new GameException(ErrCode.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            log.error("err: ", (Throwable)e);
            throw new GameException(ErrCode.INTERNAL_SERVER_ERROR);
        }
    }

    private void initStartingDate() {
        String date = this.appConfigFetcher.runtime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        this.mutablePair.set(this.getKey(), date);
        log.info("\u8bbe\u7f6e\u7cfb\u7edf\u521d\u59cb\u5316\u4e0a\u7ebf\u65e5\u671f\uff1a{}", (Object)date);
    }

    private String getKey() {
        return this.appConfigFetcher.namespace() + ".app.online.date";
    }
}

