/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.user;

import com.bxm.game.common.core.AppContext;
import com.bxm.game.common.core.vo.RedisStorageEnum;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public interface TimeBoundService {
    public static final String TYPE_ANCHOR = "anchor";
    public static final String TYPE_FREQ = "freq";
    public static final String TYPE_ASSET = "asset";

    default public List<String> ignoreBoundAnchorTypes() {
        return Arrays.asList(TYPE_ANCHOR);
    }

    default public int getTtl() {
        Long l = (AppContext.get().getBoundLimit() - System.currentTimeMillis()) / 1000L;
        return l.intValue();
    }

    default public String saveGetAnchor(int ttl, Predicate<String> predicate, Supplier<String> supplier) {
        String anchor = this.get(TYPE_ANCHOR, String.class);
        if (StringUtils.isEmpty((CharSequence)anchor) || predicate.test(anchor)) {
            anchor = supplier.get();
            this.set(TYPE_ANCHOR, anchor, ttl);
        }
        return anchor;
    }

    public Map<String, Object> getAll();

    public Map<String, RedisStorageEnum> getTypeMap();

    default public long get(String type) {
        return this.get(type, 0L);
    }

    public long get(String var1, long var2);

    public <T> T get(String var1, Class<T> var2);

    public void set(String var1, String var2, int var3);

    default public long incr(String type, int ttl) {
        return this.incrBy(type, 1L, ttl);
    }

    public long incrBy(String var1, long var2, int var4);

    default public boolean incrAndAbove(String type, long above, int ttl) {
        return this.incr(type, after -> after > above, ttl);
    }

    default public boolean incr(String type, Predicate<Long> predicate, int ttl) {
        return this.incrBy(type, 1L, predicate, ttl);
    }

    public boolean incrBy(String var1, long var2, Predicate<Long> var4, int var5);

    public void del(String var1);

    default public long hGet(String type, String field) {
        return this.hGet(type, field, 0L);
    }

    public long hGet(String var1, String var2, long var3);

    public <T> T hGet(String var1, String var2, Class<T> var3);

    public Map<String, Object> hGetAll(String var1);

    public <T> Map<String, T> hGetAll(String var1, Class<T> var2);

    public void hSet(String var1, String var2, String var3, int var4);

    default public long hIncr(String type, String field, int ttl) {
        return this.hIncrBy(type, field, 1L, ttl);
    }

    public long hIncrBy(String var1, String var2, long var3, int var5);

    default public boolean hIncrAndAbove(String type, String field, long above, int ttl) {
        return this.hIncr(type, field, after -> after > above, ttl);
    }

    default public boolean hIncr(String type, String field, Predicate<Long> predicate, int ttl) {
        return this.hIncrBy(type, field, 1L, predicate, ttl);
    }

    public boolean hIncrBy(String var1, String var2, long var3, Predicate<Long> var5, int var6);

    public void hDel(String var1, String var2);
}

