/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.user.redis;

import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.core.AppContext;
import com.bxm.game.common.core.Key;
import com.bxm.game.common.core.user.DefaultTimeBoundService;
import com.bxm.game.common.core.vo.RedisStorageEnum;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import redis.clients.jedis.JedisPool;

@ConditionalOnMissingBean(value={DefaultTimeBoundService.class})
public class RedisDefaultTimeBoundServiceImpl
implements DefaultTimeBoundService {
    private static final Logger log = LoggerFactory.getLogger(RedisDefaultTimeBoundServiceImpl.class);
    private static final Map<String, RedisStorageEnum> TYPE_MAP = new HashMap<String, RedisStorageEnum>();
    private List<String> IGNORE_BOUND_ANCHOR = new ArrayList<String>();
    protected final AppConfigFetcher appConfigFetcher;
    protected final Key key;
    protected final Fetcher fetcher;
    protected final Counter counter;
    protected final Updater updater;

    public RedisDefaultTimeBoundServiceImpl(AppConfigFetcher appConfigFetcher, Key key, @Qualifier(value="jedisFetcher") Fetcher fetcher, @Qualifier(value="jedisUpdater") Updater updater, @Qualifier(value="jedisCounter") Counter counter) {
        List<String> list;
        this.appConfigFetcher = appConfigFetcher;
        this.key = key;
        this.fetcher = fetcher;
        this.counter = counter;
        this.updater = updater;
        Map<String, RedisStorageEnum> m = this.getTypeMap();
        if (null != m) {
            TYPE_MAP.putAll(m);
        }
        if (null != (list = this.ignoreBoundAnchorTypes())) {
            this.IGNORE_BOUND_ANCHOR = list;
        }
    }

    private JedisPool getJedisPool() {
        Object original = this.fetcher.getClientOriginal();
        if (!(original instanceof JedisPool)) {
            throw new RuntimeException("originalClient is not JedisPool!");
        }
        return (JedisPool)original;
    }

    private KeyGenerator getKey(String type) {
        if (this.IGNORE_BOUND_ANCHOR.contains(type) || null == AppContext.get().getBoundAnchor()) {
            return this.key.getTimeBound(null, type, this.appConfigFetcher.timeBoundWithApp());
        }
        return this.key.getTimeBound(AppContext.get().getBoundAnchor(), type, this.appConfigFetcher.timeBoundWithApp());
    }

    @Override
    public Map<String, Object> getAll() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set<String> types = TYPE_MAP.keySet();
        for (String type : types) {
            RedisStorageEnum storageEnum = TYPE_MAP.get(type);
            Object obj = null;
            obj = RedisStorageEnum.HASH == storageEnum ? this.fetcher.hfetchall(this.getKey(type), Object.class) : this.fetcher.fetch(this.getKey(type), Object.class);
            map.put(type, obj);
        }
        return map;
    }

    @Override
    public Map<String, RedisStorageEnum> getTypeMap() {
        HashMap<String, RedisStorageEnum> map = new HashMap<String, RedisStorageEnum>();
        map.put("anchor", RedisStorageEnum.OBJECT);
        map.put("freq", RedisStorageEnum.HASH);
        map.put("asset", RedisStorageEnum.HASH);
        return map;
    }

    @Override
    public long get(String type, long defaultValue) {
        return Optional.ofNullable(this.counter.get(this.getKey(type))).orElse(defaultValue);
    }

    @Override
    public <T> T get(String type, Class<T> cls) {
        return (T)this.fetcher.fetch(this.getKey(type), cls);
    }

    @Override
    public void set(String type, String value, int ttl) {
        this.updater.update(this.getKey(type), (Object)value, ttl);
    }

    @Override
    public long incrBy(String type, long value, int ttl) {
        return Optional.ofNullable(this.counter.incrementByAndGet(this.getKey(type), value, ttl)).orElse(0L);
    }

    @Override
    public boolean incrBy(String type, long value, Predicate<Long> predicate, int ttl) {
        long l = this.incrBy(type, value);
        return predicate.test(l);
    }

    @Override
    public void del(String type) {
        this.updater.remove(this.getKey(type));
    }

    @Override
    public long hGet(String type, String field, long defaultValue) {
        return Optional.ofNullable(this.counter.hget(this.getKey(type), field)).orElse(defaultValue);
    }

    @Override
    public <T> T hGet(String type, String field, Class<T> cls) {
        return (T)this.fetcher.hfetch(this.getKey(type), field, cls);
    }

    @Override
    public Map<String, Object> hGetAll(String type) {
        return this.fetcher.hfetchall(this.getKey(type), Object.class);
    }

    @Override
    public <T> Map<String, T> hGetAll(String type, Class<T> cls) {
        return this.fetcher.hfetchall(this.getKey(type), cls);
    }

    @Override
    public void hSet(String type, String field, String value, int ttl) {
        this.updater.hupdate(this.getKey(type), field, (Object)value, ttl);
    }

    @Override
    public long hIncrBy(String type, String field, long value, int ttl) {
        return Optional.ofNullable(this.counter.hincrementByAndGet(this.getKey(type), field, value, ttl)).orElse(0L);
    }

    @Override
    public boolean hIncrBy(String type, String field, long value, Predicate<Long> predicate, int ttl) {
        long l = this.hIncrBy(type, field, value, ttl);
        return predicate.test(l);
    }

    @Override
    public void hDel(String type, String field) {
        this.updater.hremove(this.getKey(type), new String[]{field});
    }
}

