/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.user.redis;

import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.core.Key;
import com.bxm.game.common.core.user.LatelyGameService;
import com.bxm.game.common.core.vo.GameVo;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.keyvalue.DefaultKeyValue;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;

@ConditionalOnBean(name={"commonFetcher"})
public class RedisLatelyGameServiceImpl
implements LatelyGameService {
    protected final AppConfigFetcher appConfigFetcher;
    protected final Key key;
    protected final Fetcher fetcher;
    protected final Updater updater;

    public RedisLatelyGameServiceImpl(AppConfigFetcher appConfigFetcher, Key key, @Qualifier(value="commonFetcher") Fetcher fetcher, @Qualifier(value="commonUpdater") Updater updater) {
        this.appConfigFetcher = appConfigFetcher;
        this.key = key;
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public void markLatelyGame() {
        double score = System.currentTimeMillis();
        this.updater.zupdateWithSelector(this.key.getLatelyGames(), Double.valueOf(score), (Object)this.appConfigFetcher.activityType(), 2678400, 0);
    }

    @Override
    public List<GameVo> getLatelyGames(Integer days, Boolean includeSelf) {
        long start = 0L;
        if (null != days) {
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            start = DateUtils.addDays((Date)cal.getTime(), (int)(-days.intValue())).getTime();
        }
        ArrayList<GameVo> list = new ArrayList<GameVo>();
        this.fillGames(list, start, includeSelf);
        if (list.size() > 1) {
            Collections.reverse(list);
        }
        return list;
    }

    private void fillGames(List<GameVo> list, long start, Boolean includeSelf) {
        List keyValues = this.fetcher.zfetchAllWithSelector(this.key.getLatelyGames(), String.class, 0);
        Map gameMap = null;
        for (DefaultKeyValue keyValue : keyValues) {
            GameVo game;
            String k = (String)keyValue.getKey();
            Double v = (Double)keyValue.getValue();
            if (k.equals(this.appConfigFetcher.activityType()) && !includeSelf.booleanValue() || v.longValue() <= start) continue;
            if (null == gameMap) {
                gameMap = this.fetcher.hfetchall(this.key.getGameAll(), GameVo.class);
            }
            if (null == (game = (GameVo)gameMap.get(k))) continue;
            list.add(game);
        }
    }
}

