/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.user.redis;

import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.core.Key;
import com.bxm.game.common.core.user.PermanentAtomicService;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Qualifier;

public class RedisPermanentAtomicServiceImpl
implements PermanentAtomicService {
    private final AppConfigFetcher appConfigFetcher;
    private final Key key;
    private final Fetcher fetcher;
    private final Counter counter;

    public RedisPermanentAtomicServiceImpl(AppConfigFetcher appConfigFetcher, Key key, @Qualifier(value="jedisFetcher") Fetcher fetcher, @Qualifier(value="jedisCounter") Counter counter) {
        this.appConfigFetcher = appConfigFetcher;
        this.key = key;
        this.fetcher = fetcher;
        this.counter = counter;
    }

    @Override
    public Map<String, Object> getAll() {
        return this.fetcher.hfetchall(this.key.getPermanentDataForUser(this.appConfigFetcher.permanentWithApp()), Object.class);
    }

    @Override
    public long get(String key) {
        return (Long)Optional.ofNullable(this.fetcher.hfetch(this.key.getPermanentDataForUser(this.appConfigFetcher.permanentWithApp()), key, Long.class)).orElse(0L);
    }

    @Override
    public long incrementBy(String key, long value) {
        return this.counter.hincrementByAndGet(this.key.getPermanentDataForUser(this.appConfigFetcher.permanentWithApp()), key, value);
    }

    @Override
    public boolean incrementBy(String key, long value, Predicate<Long> predicate) {
        long after = this.incrementBy(key, value);
        return predicate.test(after);
    }
}

