/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.user.redis;

import com.bxm.game.common.core.AppConfigFetcher;
import com.bxm.game.common.core.Key;
import com.bxm.game.common.core.user.TodayAtomicService;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Qualifier;

public class RedisTodayAtomicServiceImpl
implements TodayAtomicService {
    private final AppConfigFetcher appConfigFetcher;
    private final Key key;
    private final Fetcher fetcher;
    private final Updater updater;
    private final Counter counter;

    public RedisTodayAtomicServiceImpl(AppConfigFetcher appConfigFetcher, Key key, @Qualifier(value="jedisFetcher") Fetcher fetcher, @Qualifier(value="jedisUpdater") Updater updater, @Qualifier(value="jedisCounter") Counter counter) {
        this.appConfigFetcher = appConfigFetcher;
        this.key = key;
        this.fetcher = fetcher;
        this.updater = updater;
        this.counter = counter;
    }

    @Override
    public Map<String, Object> getAll() {
        return this.fetcher.hfetchall(this.key.getTodayDataForUser(this.appConfigFetcher.todayWithApp()), Object.class);
    }

    @Override
    public long get(String key) {
        return Optional.ofNullable(this.counter.hget(this.key.getTodayDataForUser(this.appConfigFetcher.todayWithApp()), key)).orElse(0L);
    }

    @Override
    public long incrementBy(String key, long value) {
        return Optional.ofNullable(this.counter.hincrementByAndGet(this.key.getTodayDataForUser(this.appConfigFetcher.todayWithApp()), key, value, 86400)).orElse(0L);
    }

    @Override
    public boolean incrementBy(String key, long value, Predicate<Long> predicate) {
        long l = this.incrementBy(key, value);
        return predicate.test(l);
    }

    @Override
    public void delete(String key) {
        this.updater.hremove(this.key.getTodayDataForUser(this.appConfigFetcher.todayWithApp()), new String[]{key});
    }
}

