/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.vo;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.game.common.core.vo.Constructor;
import com.bxm.game.common.core.vo.Extractor;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public final class PageHelper {
    public static <T> IPage<T> create(IPage<?> source, List<T> records) {
        return PageHelper.create(source.getCurrent(), source.getSize(), source.getTotal(), records);
    }

    public static <T> IPage<T> create(long current, long size, long total, List<T> records) {
        Page page = new Page(current, size, total);
        page.setRecords(records);
        return page;
    }

    public static <S, D> IPage<D> selectForObject(int current, int size, Extractor<S> extractor, Constructor<S, D> constructor) {
        Page page = new Page((long)current, (long)size);
        IPage<S> extract = extractor.extract((IPage<S>)page);
        if (null == extract) {
            return null;
        }
        Page result = new Page(extract.getCurrent(), extract.getSize(), extract.getTotal());
        List records = extract.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return result;
        }
        List list = records.stream().map(constructor::construct).collect(Collectors.toList());
        result.setRecords(list);
        return result;
    }
}

