/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.common.core.web;

import com.bxm.game.common.core.ErrCode;
import com.bxm.game.common.core.GameException;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Integer> exception(Exception e) {
        ErrCode errCode = ErrCode.INTERNAL_SERVER_ERROR;
        log.error("Internal server error: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        return ResponseEntity.status((int)errCode.getStatusCode()).body((Object)errCode.getCode());
    }

    @ExceptionHandler(value={GameException.class})
    public ResponseEntity<Integer> fruitsException(GameException e) {
        ErrCode errCode = e.getErrCode();
        if (Objects.isNull(errCode)) {
            return ResponseEntity.badRequest().body((Object)-1);
        }
        return ResponseEntity.status((int)errCode.getStatusCode()).body((Object)errCode.getCode());
    }

    @ExceptionHandler(value={UnsupportedOperationException.class})
    public ResponseEntity<String> unsupportedOperation() {
        return ResponseEntity.notFound().build();
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<String> httpMessageNotReadable() {
        return ResponseEntity.badRequest().build();
    }

    @ExceptionHandler(value={IllegalArgumentException.class, DateTimeParseException.class, MissingServletRequestParameterException.class})
    public ResponseEntity<String> illegalArgument(Throwable throwable) {
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)throwable.getMessage());
    }

    @ExceptionHandler(value={BindException.class})
    public ResponseEntity<String> bindException(BindException throwable) {
        StringBuilder msg = new StringBuilder();
        List errors = throwable.getAllErrors();
        for (ObjectError error : errors) {
            msg.append(error.getDefaultMessage());
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)msg.toString());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<String> methodArgumentNotValidException(MethodArgumentNotValidException throwable) {
        StringBuilder msg = new StringBuilder();
        BindingResult bindingResult = throwable.getBindingResult();
        List errors = bindingResult.getAllErrors();
        for (ObjectError error : errors) {
            msg.append(error.getDefaultMessage());
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)msg.toString());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<String> constraintViolationException(ConstraintViolationException throwable) {
        StringBuilder msg = new StringBuilder();
        Set constraintViolations = throwable.getConstraintViolations();
        for (ConstraintViolation constraintViolation : constraintViolations) {
            msg.append(constraintViolation.getMessage());
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)msg.toString());
    }
}

