package com.bxm.game.common.core;


import com.bxm.warcar.integration.dc.dot.Device;

/**
 * @author allen
 * @date 2020-10-14
 * @since 1.0
 */
public class AppContext {

    private static final ThreadLocal<AppContext> THREAD_LOCAL = new ThreadLocal<>();

    public static AppContext getInstance() {
        AppContext appContext = THREAD_LOCAL.get();
        if (null == appContext) {
            appContext = new AppContext();
            THREAD_LOCAL.set(appContext);
        }
        return appContext;
    }

    public static AppContext get() {
        return THREAD_LOCAL.get();
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }

    /**
     * x-appid
     */
    private String appId;
    /**
     * 设备id
     * 取自x-device,主要用于多项目间的数据互通，比如钱包
     */
    private String xDevice;
    /**
     * 设备uid(可能值：xdevice/Device中的某个值/userDao.getUid())
     */
    private String devUid;
    /**
     * 自定义用户id
     */
    private String uid;
    /**
     * did密文
     */
    private String did;
    /**
     * 设备id
     * 取自did解密后的数据，主要用于多项目间的数据互通，比如钱包
     */
    private String didDevice;
    /**
     * did明文
     */
    private Device device;
    /**
     * 时效数据锚定日期
     */
    private String boundAnchor;
    /**
     * 时效数据最终过期时间戳
     */
    private long boundLimit;
    /**
     * 具体项目中可能存在的扩展信息
     */
    private AppContextExt ext;

    public AppContext setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String getAppId() {
        return appId;
    }

    public AppContext setXDevice(String xDevice) {
        this.xDevice = xDevice;
        return this;
    }

    public String getXDevice() {
        return xDevice;
    }

    public AppContext setDevUid(String devUid) {
        this.devUid = devUid;
        return this;
    }

    public String getDevUid() {
        return devUid;
    }

    public AppContext setUid(String uid) {
        this.uid = uid;
        return this;
    }

    public String getUid() {
        return uid;
    }

    public String getDid() {
        return did;
    }

    public AppContext setDid(String did) {
        this.did = did;
        return this;
    }

    public AppContext setDidDevice(String didDevice) {
        this.didDevice = didDevice;
        return this;
    }

    public String getDidDevice() {
        return didDevice;
    }

    public Device getDevice() {
        return device;
    }

    public AppContext setDevice(Device device) {
        this.device = device;
        return this;
    }

    public String getBoundAnchor() {
        return boundAnchor;
    }

    public void setBoundAnchor(String boundAnchor) {
        this.boundAnchor = boundAnchor;
    }

    public long getBoundLimit() {
        return boundLimit;
    }

    public void setBoundLimit(long boundLimit) {
        this.boundLimit = boundLimit;
    }

    public AppContextExt getExt() {
        return ext;
    }

    public void setExt(AppContextExt ext) {
        this.ext = ext;
    }
}
