package com.bxm.game.common.core;

import java.util.regex.Pattern;

/**
 * 常量<br/>
 *
 * @author kerry.jiang
 * @date 2021/1/12 18:45
 */
public class Consts {

    /**
     * 资产Redis key分析
     * 例如：game:farms-api:assets:{appid}:{uid}
     */
    public static final Pattern PATTERN_ASSET = Pattern.compile("game:.*:assets:(\\w*):(\\w*)");

    /**
     * 资产Redis key分析
     * 例如：game:cow:bound:20210615:{appid}:{uid}:asset
     */
    public static final Pattern PATTERN_BOUND_ASSET = Pattern.compile("game:.*:bound:((\\w*):)?(\\w*):(\\w*):asset");

    /**
     * 资产Redis key分析
     // game:cow:bound:{appid}:{uid}:anchor
     */
    public static final Pattern PATTERN_ANCHOR = Pattern.compile("game:.*:bound:(\\w*):(\\w*):anchor");

    /**
     * 最近玩的游戏，用户最长闲置时间（31天）
     */
    public static final int LATELY_GAME_TTL = 60 * 60 * 24 * 31;
    /**
     * 最近玩的游戏，DB库
     */
    public static final int LATELY_GAME_DB = 0;
}
