package com.bxm.game.common.core;


import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;

/**
 * @author allen
 * @date 2020-12-09
 * @since 1.0
 */
@ConditionalOnMissingBean(AppConfigFetcher.class)
public class EmptyAppConfigFetcher implements AppConfigFetcher {

    @Value("${spring.application.name}")
    private String applicationName;

    @Override
    public String namespace() {
        return applicationName;
    }
}
