package com.bxm.game.common.core;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

/**
 * @author allen
 * @date 2020-10-16
 * @since 1.0
 */
@Data
@Builder
@AllArgsConstructor
public class ErrCode {

    public static final ErrCode BAD_REQUEST                  = ErrCode.builder().code(400).statusCode(400).msg("BAD_REQUEST").build();
    public static final ErrCode NOT_MEET_ACQUIRING_CONDITION = ErrCode.builder().code(401).statusCode(400).msg("不满足领取条件").build();
    public static final ErrCode NOT_MEET_MULTIPLE_CONDITION  = ErrCode.builder().code(402).statusCode(400).msg("不满足翻倍条件").build();
    public static final ErrCode WITHDRAW_ERR  = ErrCode.builder().code(403).statusCode(400).msg("提现失败").build();
    public static final ErrCode CONDITION_LIMIT  = ErrCode.builder().code(404).statusCode(400).msg("条件限制").build();
    public static final ErrCode NOT_TAKE_PROP  = ErrCode.builder().code(405).statusCode(400).msg("不能产生道具").build();
    public static final ErrCode INTERNAL_SERVER_ERROR        = ErrCode.builder().code(500).statusCode(500).msg("INTERNAL_SERVER_ERROR").build();
    public static final ErrCode CONFIG_INVALID               = ErrCode.builder().code(900).statusCode(500).msg("游戏配置无效").build();
    public static final ErrCode CLOSED                       = ErrCode.builder().code(-1).statusCode(503).msg("服务器维护中").build();

    private int code;
    private int statusCode;
    private String msg;
}
