package com.bxm.game.common.core;

import com.bxm.warcar.integration.dc.dot.Device;
import org.apache.commons.lang.StringUtils;

/**
 * 请求头处理器
 *
 * @author allen
 * @date 2021-04-09
 * @since 1.0
 */
public interface RequestHeaderHandler {

    /**
     * <p>是否重写 {@code x-device} 值</p>
     * <p>如果返回 {@code true}，那首先从请求头的 {@code x-did} 值解密后，然后通过 {@link #fetchDeviceValue(Device)} 获得新的值并覆盖原始的 {@code x-device}。</p>
     * <p>如果返回 {@code false}，则使用原始的 {@code x-device} 值作为{@code UID}来使用，该值的来源于请求头的 {@code x-device}。</p>
     * @param appid x-appid
     * @param xDevice x-device
     * @param device x-did 解密后的{@link Device}
     * @return 默认：false
     * @since 1.2.5.3
     * @see #fetchDeviceValue(Device)
     * @see com.bxm.game.common.core.interceptor.AppContextInterceptor
     */
    default boolean isOverrideDeviceValue(String appid, String xDevice, Device device) {
        return false;
    }

    /**
     * 从{@link Device}对象中获取一个{@code x-device}值。
     * @param device 设备信息
     * @return {@code x-device}值。
     */
    default String fetchDeviceValue(Device device) {
        if (StringUtils.isNotBlank(device.getImei())) {
            return device.getImei();
        } else if (StringUtils.isNotBlank(device.getAnid())) {
            return device.getAnid();
        } else if (StringUtils.isNotBlank(device.getIdfa())) {
            return device.getIdfa();
        } else if (StringUtils.isNotBlank(device.getImeiMd5())) {
            return device.getImeiMd5();
        } else if (StringUtils.isNotBlank(device.getAnidMd5())) {
            return device.getAnidMd5();
        } else if (StringUtils.isNotBlank(device.getOaid())) {
            return device.getOaid();
        } else if (StringUtils.isNotBlank(device.getIdfaMd5())) {
            return device.getIdfaMd5();
        }
        return null;
    }
}
