package com.bxm.game.common.core.activity.dao;

import java.util.Objects;

import org.springframework.beans.factory.annotation.Qualifier;

import com.bxm.game.common.core.AppConfig;
import com.bxm.game.common.core.ErrCode;
import com.bxm.game.common.core.GameException;
import com.bxm.game.common.core.activity.ActivityConfig;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;

/**
 * @author allen
 * @date 2020-10-19
 * @since 1.0
 */
public class DefaultActivityDaoImpl implements ActivityDao {

    private final AppConfig appConfig;
    private final Fetcher fetcher;

    public DefaultActivityDaoImpl(AppConfig appConfig,
                                  @Qualifier("jedisFetcher") Fetcher fetcher) {
        this.appConfig = appConfig;
        this.fetcher = fetcher;
    }

    @Override
    public ActivityConfig get(String appId) {
        ActivityCachingConfig caching = getCaching(appId);
        if (Objects.isNull(caching)) {
            caching = getCaching("default");
            if (Objects.isNull(caching)) {
                throw new GameException(ErrCode.CONFIG_INVALID);
            }
        }

        ActivityConfig.ActivityConfigBuilder builder = ActivityConfig.builder();

        builder.appId(caching.getAppId());
        builder.title(caching.getTitle());
        builder.config(caching.getConfig());

        return builder.build();
    }

    @Override
    public <T> T getConfig(String appId, Class<T> clazz) {
        T config = getConfig0(appId, clazz);
        if (Objects.isNull(config)) {
            config = getConfig0("default", clazz);
            if (Objects.isNull(config)) {
                throw new GameException(ErrCode.CONFIG_INVALID);
            }
        }
        return config;
    }

    private ActivityCachingConfig getCaching(String appId) {
        return fetcher.hfetch(hash(), appId, ActivityCachingConfig.class);
    }

    private <T> T getConfig0(String appId, Class<T> clazz) {
        return fetcher.hfetch(hash(), appId, clazz);
    }

    private KeyGenerator hash() {
        return () -> KeyBuilder.build("game", appConfig.getNamespace(), "config");
    }
}
