package com.bxm.game.common.core.api.user;

/**
 * 用户映射服务<br/>
 *
 * @author kerry.jiang
 * @date 2021/6/30 14:11
 */
public interface BxmUserMappingService {

    /**
     * 根据变现猫用户ID获取媒体的用户ID<br/>
     *
     * @param appid appid
     * @param uid 变现猫用户ID
     * @return
     */
    String getByUid(String appid, String uid);

    /**
     * 根据媒体的用户ID获取变现猫用户ID<br/>
     *
     * @param appid appid
     * @param cuid 媒体的用户ID
     * @return
     */
    String getByCuid(String appid, String cuid);
}
