package com.bxm.game.common.core.api.user;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import com.bxm.game.common.core.ErrCode;
import com.bxm.game.common.core.GameException;

import lombok.extern.slf4j.Slf4j;

/**
 * 用户映射服务<br/>
 *
 * @author kerry.jiang
 * @date 2021/6/30 14:11
 */
@Slf4j
public abstract class EmptyBxmUserMappingServiceImpl implements BxmUserMappingService {

    private final RestTemplate restTemplate;
    private final String getByUidUrl;
    private final String getByCuidUrl;

    public EmptyBxmUserMappingServiceImpl(RestTemplate restTemplate, String apiUrl){
        this.restTemplate = restTemplate;
        this.getByUidUrl = StringUtils.join(apiUrl, "/userMapping/getByUid");
        this.getByCuidUrl = StringUtils.join(apiUrl, "/userMapping/getByCuid");
    }

    @Override
    public String getByUid(String appid, String uid) {
        ResponseEntity<String> entity;
        try {
            StringBuilder url = new StringBuilder(getByUidUrl);
            url.append("?appId=");
            url.append(appid);
            url.append("&uid=");
            url.append(uid);
            entity = restTemplate.exchange(url.toString(), HttpMethod.GET, null,
                    String.class);
        }catch (ResourceAccessException e){
            log.error("getByUid error: appid={},uid={},e={}",
                    appid, uid, ExceptionUtils.getFullStackTrace(e));
            throw new GameException(ErrCode.INTERNAL_SERVER_ERROR);
        }catch (Exception e){
            log.error("getByUid error: appid={},uid={},e={}",
                    appid, uid, ExceptionUtils.getFullStackTrace(e));
            throw new GameException(ErrCode.INTERNAL_SERVER_ERROR);
        }

        HttpStatus httpStatus = entity.getStatusCode();
        if(HttpStatus.OK == httpStatus){
            return entity.getBody();
        }else{
            log.error("getByUid fail: httpStatus={},appid={},uid={},body={}",
                    httpStatus.value(), appid, uid, entity.getBody());
            throw new GameException(ErrCode.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public String getByCuid(String appid, String cuid) {
        ResponseEntity<String> entity;
        try {
            StringBuilder url = new StringBuilder(getByCuidUrl);
            url.append("?appId=");
            url.append(appid);
            url.append("&cuid=");
            url.append(cuid);
            entity = restTemplate.exchange(url.toString(), HttpMethod.GET, null,
                    String.class);
        }catch (ResourceAccessException e){
            log.error("getByCuid error: appid={},cuid={},e={}",
                    appid, cuid, ExceptionUtils.getFullStackTrace(e));
            throw new GameException(ErrCode.INTERNAL_SERVER_ERROR);
        }catch (Exception e){
            log.error("getByCuid error: appid={},cuid={},e={}",
                    appid, cuid, ExceptionUtils.getFullStackTrace(e));
            throw new GameException(ErrCode.INTERNAL_SERVER_ERROR);
        }

        HttpStatus httpStatus = entity.getStatusCode();
        if(HttpStatus.OK == httpStatus){
            return entity.getBody();
        }else{
            log.error("getByCuid fail: httpStatus={},appid={},cuid={},body={}",
                    httpStatus.value(), appid, cuid, entity.getBody());
            throw new GameException(ErrCode.INTERNAL_SERVER_ERROR);
        }
    }
}
