package com.bxm.game.common.core.api.wallet;

/**
 * 变现猫钱包服务<br/>
 *
 * @author kerry.jiang
 * @date 2021/6/30 17:06
 */
public interface BxmWalletService {

    /**
     * 默认header信息
     *
     * @return
     */
    WalletHeaderRequest getDefaultHeaderRequest();

    /**
     * 兑换现金<br/>
     *
     * @param request 请求信息
     * @return
     */
    default void exchangeMoney(WalletExchangeRequest request){
        exchangeMoney(request, getDefaultHeaderRequest());
    }

    /**
     * 兑换现金<br/>
     *
     * @param request 请求信息
     * @param header header信息
     * @return
     */
    void exchangeMoney(WalletExchangeRequest request, WalletHeaderRequest header);

    /**
     * 获取现金<br/>
     *
     * @return
     */
    default WalletFetchInfo fetchInfo(){
        return fetchInfo(getDefaultHeaderRequest());
    }

    /**
     * 获取现金<br/>
     *
     * @param header header信息
     * @return
     */
    WalletFetchInfo fetchInfo(WalletHeaderRequest header);

}
