package com.bxm.game.common.core.api.wallet;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.*;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.bxm.game.common.core.ErrCode;
import com.bxm.game.common.core.GameException;
import com.bxm.warcar.utils.JsonHelper;

import lombok.extern.slf4j.Slf4j;

/**
 * 变现猫钱包服务<br/>
 *
 * @author kerry.jiang
 * @date 2021/6/30 17:06
 */
@Slf4j
public abstract class EmptyBxmWalletServiceImpl implements BxmWalletService {

    protected final String X_APPID = "x-appid";
    protected final String X_DEVICE = "x-device";

    protected final RestTemplate restTemplate;
    protected final String exchangeMoneyUrl;
    protected final String fetchUrl;

    public EmptyBxmWalletServiceImpl(RestTemplate restTemplate, String apiUrl){
        this.restTemplate = restTemplate;
        this.exchangeMoneyUrl = StringUtils.join(apiUrl, "/scene/take/activity");
        this.fetchUrl = StringUtils.join(apiUrl, "/archive/fetch");
    }

    @Override
    public void exchangeMoney(WalletExchangeRequest request, WalletHeaderRequest header) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add(X_APPID, header.getAppid());
        headers.add(X_DEVICE, header.getUid());
        String paramJson = null;
        ResponseEntity<String> entity;
        try {
            paramJson = JsonHelper.convert(request);

            HttpEntity httpEntity = new HttpEntity(paramJson, headers);
            entity = restTemplate.postForEntity(exchangeMoneyUrl, httpEntity, String.class);
        }catch (ResourceAccessException e){
            log.error("exchangeMoney error: paramJson={},header={},e={}",
                    paramJson, header, ExceptionUtils.getFullStackTrace(e));
            throw new GameException(ErrCode.INTERNAL_SERVER_ERROR);
        }catch (Exception e){
            log.error("exchangeMoney error: paramJson={},header={},e={}",
                    paramJson, header, ExceptionUtils.getFullStackTrace(e));
            throw new GameException(ErrCode.INTERNAL_SERVER_ERROR);
        }

        HttpStatus httpStatus = entity.getStatusCode();
        if(HttpStatus.OK == httpStatus){
            WalletExchange ret = JSON.parseObject(entity.getBody(),
                    new TypeReference<WalletExchange>() {});
            if(null == ret || null == ret.getId()){
                log.error("exchangeMoney fail: paramJson={},header={},body={}",
                        paramJson, header, entity.getBody());
                throw new GameException(ErrCode.INTERNAL_SERVER_ERROR);
            }
        }else{
            log.error("exchangeMoney fail: httpStatus={},paramJson={},header={},body={}",
                    httpStatus.value(), paramJson, header, entity.getBody());
            throw new GameException(ErrCode.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public WalletFetchInfo fetchInfo(WalletHeaderRequest header) {
        HttpHeaders headers = new HttpHeaders();
        headers.add(X_APPID, header.getAppid());
        headers.add(X_DEVICE, header.getUid());
        ResponseEntity<String> entity;
        try {
            HttpEntity httpEntity = new HttpEntity(null, headers);
            entity = restTemplate.exchange(fetchUrl, HttpMethod.GET, httpEntity,
                    String.class);
        }catch (ResourceAccessException e){
            log.error("fetchInfo error: header={},e={}",
                    header, ExceptionUtils.getFullStackTrace(e));
            throw new GameException(ErrCode.INTERNAL_SERVER_ERROR);
        }catch (Exception e){
            log.error("fetchInfo error: header={},e={}",
                    header, ExceptionUtils.getFullStackTrace(e));
            throw new GameException(ErrCode.INTERNAL_SERVER_ERROR);
        }

        HttpStatus httpStatus = entity.getStatusCode();
        if(HttpStatus.OK == httpStatus){
            WalletFetchInfo ret = JSON.parseObject(entity.getBody(),
                    new TypeReference<WalletFetchInfo>() {});
            if(null == ret){
                log.error("fetchInfo fail: header={},body={}",
                        header, entity.getBody());
                throw new GameException(ErrCode.INTERNAL_SERVER_ERROR);
            }else{
                return ret;
            }
        }else{
            log.error("fetchInfo fail: httpStatus={},header={},body={}",
                    httpStatus.value(), header, entity.getBody());
            throw new GameException(ErrCode.INTERNAL_SERVER_ERROR);
        }
    }
}
